<?= $this->include('layout/header_admin') ?>

<div class="container mt-4">
    <div class="card shadow">
        <div class="card-header bg-warning">
            <h5 class="mb-0">✏️ Edit Biodata</h5>
        </div>

        <div class="card-body">
            <form action="/auth/biodata/update/<?= $biodata['id'] ?>"
                method="post"
                enctype="multipart/form-data">

                <!-- FOTO -->
                <div class="mb-3 text-center">
                    <label class="form-label">Foto Profil</label>
                    <input type="file" name="foto" class="form-control" accept="image/*">

                    <?php if (!empty($biodata['foto'])) : ?>
                        <div class="mt-2">
                            <img src="/uploads/biodata/<?= esc($biodata['foto']) ?>"
                                class="img-thumbnail"
                                width="120">
                        </div>
                    <?php endif ?>
                </div>

                <!-- NAMA -->
                <div class="mb-3">
                    <label class="form-label">Nama Lengkap</label>
                    <input type="text" name="nama"
                        class="form-control"
                        value="<?= esc($biodata['nama']) ?>"
                        required>
                </div>

                <!-- NIM -->
                <div class="mb-3">
                    <label class="form-label">NIM</label>
                    <input type="text" name="nim"
                        class="form-control"
                        value="<?= esc($biodata['nim']) ?>"
                        required>
                </div>

                <!-- JENIS KELAMIN -->
                <div class="mb-3">
                    <label class="form-label">Jenis Kelamin</label>
                    <select name="jenis_kelamin" class="form-select" required>
                        <option value="">-- Pilih --</option>
                        <option value="Laki-laki"
                            <?= $biodata['jenis_kelamin'] == 'Laki-laki' ? 'selected' : '' ?>>
                            Laki-laki
                        </option>
                        <option value="Perempuan"
                            <?= $biodata['jenis_kelamin'] == 'Perempuan' ? 'selected' : '' ?>>
                            Perempuan
                        </option>
                    </select>
                </div>

                <!-- TEMPAT LAHIR -->
                <div class="mb-3">
                    <label class="form-label">Tempat Lahir</label>
                    <input type="text" name="tempat_lahir"
                        class="form-control"
                        value="<?= esc($biodata['tempat_lahir']) ?>"
                        required>
                </div>

                <!-- TANGGAL LAHIR -->
                <div class="mb-3">
                    <label class="form-label">Tanggal Lahir</label>
                    <input type="date" name="tanggal_lahir"
                        class="form-control"
                        value="<?= esc($biodata['tanggal_lahir']) ?>"
                        required>
                </div>

                <!-- ALAMAT -->
                <div class="mb-3">
                    <label class="form-label">Alamat</label>
                    <textarea name="alamat"
                        class="form-control"
                        rows="3"
                        required><?= esc($biodata['alamat']) ?></textarea>
                </div>

                <!-- NO HP -->
                <div class="mb-3">
                    <label class="form-label">No HP</label>
                    <input type="text" name="no_hp"
                        class="form-control"
                        value="<?= esc($biodata['no_hp']) ?>"
                        required>
                </div>

                <!-- EMAIL -->
                <div class="mb-3">
                    <label class="form-label">Email</label>
                    <input type="email" name="email"
                        class="form-control"
                        value="<?= esc($biodata['email']) ?>"
                        required>
                </div>

                <!-- BUTTON -->
                <div class="d-flex justify-content-between">
                    <a href="/auth/biodata" class="btn btn-secondary">
                        ⬅ Kembali
                    </a>
                    <button class="btn btn-success">
                        💾 Update
                    </button>
                </div>

            </form>
        </div>
    </div>
</div>

<?= $this->include('layout/footer_admin') ?>